﻿// initialize validation messages variable
$.validation = {
    messages: {}
};

// add validation templates to show fancy icons with message text
$.extend($.validation.messages, {
    required: '<i class="fa fa-exclamation-circle"></i> required.',
    email: '<i class="fa fa-exclamation-circle"></i> Please enter a valid email.',
});

// call our 'validateLoginForm' function when page is ready
$(document).ready(function () {
    validateLoginForm();
});

// bind jQuery validation event and form 'submit' event
var validateLoginForm = function () {
    var form_login = $('#form_login');
    var login_result = $('#login_result');

    // bind jQuery validation event
    form_login.validate({
        rules: {
            login_email: {
                required: true,     // email field is required
                email: true         // validate email address
            },
            login_password: {
                required: true      // password field is required
            }
        },
        messages: {
            login_email: {
                required: $.validation.messages.required,
                email: $.validation.messages.email
            },
            login_password: {
                required: $.validation.messages.required
            }
        },
        errorPlacement: function (error, element) {
            // insert error message after invalid element
            error.insertAfter(element);

            // hide error message on window resize event
            $(window).resize(function () {
                error.remove();
            });
        },
        invalidHandler: function (event, validator) {
            var errors = validator.numberOfInvalids();
            if (errors) {
            } else {
            }
        }
    });

    var login_email = $('#login_email');
    var login_password = $('#login_password');
    var login_remember = $('#login_remember');

    // bind form submit event
    form_login.on('submit', function (e) {
        var remember = login_remember.is(':checked') ? 1 : 0;

        // if form is valid then call AJAX script
        if (form_login.valid()) {
            var ajaxRequest = $.ajax({
                url: 'ajax/login.php',
                type: "POST",
                data: {
                    email: login_email.val(),
                    password: login_password.val(),
                    remember: remember
                },
                beforeSend: function () {
                }
            });

            ajaxRequest.fail(function (data, status, errorThrown) {
                // error
                var $message = data.responseText;
                login_result.html('<div class="alert alert-danger">' + $message + '</div>');
            });

            ajaxRequest.done(function (response) {
                // done
                var $response = $.parseJSON(response);
                login_result.html('<div class="alert alert-success">' + $response.message + '</div>');
            });
        }

        // stop default submit event of form
        e.preventDefault();
        e.stopPropagation();
    });
}