﻿// initialize validation messages variable
$.validation = {
    messages: {}
};

// add validation templates to show fancy icons with message text
$.extend($.validation.messages, {
    required: '<i class="fa fa-exclamation-circle"></i> required.',
    email: '<i class="fa fa-exclamation-circle"></i> Please enter a valid email.',
});

// call our 'validateContactForm' function when page is ready
$(document).ready(function () {
    validateContactForm();
});

// bind jQuery validation event and form 'submit' event
var validateContactForm = function () {
    var modal_contact = $('#modal_contact');
    var modal_form_contact = $('#modal_form_contact');
    var modal_contact_result = $('#modal_contact_result');

    // bind jQuery validation event
    modal_form_contact.validate({
        rules: {
            modal_contact_firstname: {
                required: true      // firstname field is required
            },
            modal_contact_lastname: {
                required: true      // lastname field is required
            },
            modal_contact_email: {
                required: true,     // email field is required
                email: true         // validate email address
            },
            modal_contact_message: {
                required: true      // message field is required
            }
        },
        messages: {
            modal_contact_firstname: {
                required: $.validation.messages.required
            },
            modal_contact_lastname: {
                required: $.validation.messages.required
            },
            modal_contact_email: {
                required: $.validation.messages.required,
                email: $.validation.messages.email
            },
            modal_contact_message: {
                required: $.validation.messages.required
            }
        },
        errorPlacement: function (error, element) {
            // insert error message after invalid element
            error.insertAfter(element);

            // hide error message on window resize event
            $(window).resize(function () {
                error.remove();
            });
        },
        invalidHandler: function (event, validator) {
            var errors = validator.numberOfInvalids();
            if (errors) {
            } else {
            }
        }
    });

    var modal_contact_firstname = $('#modal_contact_firstname');
    var modal_contact_lastname = $('#modal_contact_lastname');
    var modal_contact_email = $('#modal_contact_email');
    var modal_contact_message = $('#modal_contact_message');

    // bind form submit event
    modal_form_contact.on('submit', function (e) {
        // if form is valid then call AJAX script
        if (modal_form_contact.valid()) {
            var ajaxRequest = $.ajax({
                url: 'ajax/contact.php',
                type: "POST",
                data: {
                    firstname: modal_contact_firstname.val(),
                    lastname: modal_contact_lastname.val(),
                    email: modal_contact_email.val(),
                    message: modal_contact_message.val()
                },
                beforeSend: function () {
                }
            });

            ajaxRequest.fail(function (data, status, errorThrown) {
                // error
                var $message = data.responseText;
                modal_contact_result.html('<div class="alert alert-danger">' + $message + '</div>');
                modal_contact.modal('hide');
            });

            ajaxRequest.done(function (response) {
                // done
                var $response = $.parseJSON(response);
                modal_contact_result.html('<div class="alert alert-success">' + $response.message + '</div>');
                modal_contact.modal('hide');
            });
        }

        // stop default submit event of form
        e.preventDefault();
        e.stopPropagation();
    });

    modal_contact.on('hide.bs.modal', function (e) {
        // reset form fields and validation errors
        modal_form_contact.validate().resetForm();
        modal_form_contact.trigger('reset');
    });
}